


export class DayPriceEditWidget {

	tpl = `
		<div class="dayprice-edit-widget">
			<div class="page-header">
				<div class="toolbox">
					<a href="javascript:void(0);" [onclick]="widget.goBack_Click" class="fa fa-chevron-circle-left"></a>
					
					<a ez-if="dayprice.daypriceId ? true : false" href="javascript:void(0);" [onclick]="widget.delete_Click" class="fa fa-trash"></a>
					
					<a href="javascript:void(0);" [onclick]="widget.save_Click" class="fa fa-save"></a>
				</div>
				
				<h1>{{_('Day price')}}</h1>
			</div>
			
			
			
			<ez-text label="Name" name="name" [value]="dayprice.name"></ez-text>
			
			
			<div class="action-box">
				<span><a href="javascript:void(0);" [onclick]="widget.addDaypriceEntry_Click">{{_('Add price rule')}}</a></span>
			</div>
			
			<div class="dayprice-edit-settings">
				<ez-date label="Start date" 
							name="startDate" 
							[value]="startDate"></ez-date>
			
				<ez-number label="Days shown" 
							name="daysShown" 
							[value]="daysShown"
							[onchange]="widget.daysShown_Change"
							min="10"
							max="500"></ez-number>
			</div>
			
			
			<div id="container-dp-entries"></div>
			
			<div id="container-dp-entry"></div>
		</div>
	`;
	
	
	tplEntryList = `
		<table class="tbl-entries">
			<thead>
				<tr ez-for="months" ez-item="m" class="month-list">
					<td [colspan]="m.days_left">
						{{_('monthshort.'+m.month)}}
						{{ m.year != currentYear ? ("'"+m.short_year) : '' }}
					</td>
				</td>
				<tr ez-for="days" ez-item="d" class="day-list">
					<td>{{d.date}}</td>
				</tr>
			</thead>
			<tbody ez-for="dayEntries" ez-item="de">
				<tr [onclick]="widget.editEntry_Click" [de]="de">
					<td>{{ de.description != '' ? de.description : '&nbsp;' }}</td>
					<td ez-forme="de.days" ez-item="ded" class="{{ded.arrivalDay ? 'day-arrival' : '' }} {{ded.departureDay ? 'day-departure' : '' }}">
					</td>
				</tr>
			</tbody>
		</table>
	`;
	
	tplEntryForm = `
		<div class="dayprice-entry-form-spacer"></div>
		
		<div class="dayprice-entry-form">
			<ez-text name="description" label="{{_('Description')}}" [value]="entry.description" placeholder="{{_('Description')}}"></ez-text>
			
			<div class="input-price">
				<ez-price name="price" label="Price" [value]="entry.price"></ez-price>
				
				<ez-select name="priceMethod" label="Method" [value]="entry.priceMethod" [onchange]="widget.priceMethod_Change">
					<option value="night">{{_('Per night')}}</option>
					<option value="day">{{_('Per day')}}</option>
					<option value="fixed">{{_('Fixed')}}</option>
				</ez-select>
			</div>
			
			<div class="start-end">
				<ez-date name="dpStartDate" label="Start" [value]="entry.startDate"></ez-date>
				<span class="from-to">t/m</span>
				<ez-date name="dpEndDate" label="Eind" [value]="entry.endDate"></ez-date>
			</div>	
			
			<div class="min-max-duration">
				<ez-number name="minDuration" label="Min. duur" min="1" [value]="entry.minDuration"></ez-number>
				<ez-number name="maxDuration" label="Max. duur" min="1" [value]="entry.maxDuration"></ez-number>
			</div>
			
			<div class="duration hidden">
				<ez-number name="duration" label="Duur" min="1" [value]="entry.minDuration"></ez-number>
				
				<ez-radio name="durationType" label="" [value]="entry.durationType">
					<option value="night">{{_('Per night')}}</option>
					<option value="day">{{_('Per day')}}</option>
				</ez-radio>
			</div>
		
			Aankomst dagen
			<table>
				<tr>
					<th>{{_('daynoshort.1')}}</th>
					<th>{{_('daynoshort.2')}}</th>
					<th>{{_('daynoshort.3')}}</th>
					<th>{{_('daynoshort.4')}}</th>
					<th>{{_('daynoshort.5')}}</th>
					<th>{{_('daynoshort.6')}}</th>
					<th>{{_('daynoshort.7')}}</th>
				</tr>
				<tr>
					<td><input type="checkbox" [checked]="entry.arrivalDay1" name="arrivalDay1" /></td>
					<td><input type="checkbox" [checked]="entry.arrivalDay2" name="arrivalDay2" /></td>
					<td><input type="checkbox" [checked]="entry.arrivalDay3" name="arrivalDay3" /></td>
					<td><input type="checkbox" [checked]="entry.arrivalDay4" name="arrivalDay4" /></td>
					<td><input type="checkbox" [checked]="entry.arrivalDay5" name="arrivalDay5" /></td>
					<td><input type="checkbox" [checked]="entry.arrivalDay6" name="arrivalDay6" /></td>
					<td><input type="checkbox" [checked]="entry.arrivalDay7" name="arrivalDay7" /></td>
				</tr>
			</table>
			
			<div class="container-departure-days">
				Vertrek dagen
				<table>
					<tr>
						<th>{{_('daynoshort.1')}}</th>
						<th>{{_('daynoshort.2')}}</th>
						<th>{{_('daynoshort.3')}}</th>
						<th>{{_('daynoshort.4')}}</th>
						<th>{{_('daynoshort.5')}}</th>
						<th>{{_('daynoshort.6')}}</th>
						<th>{{_('daynoshort.7')}}</th>
					</tr>
					<tr>
						<td><input type="checkbox" [checked]="entry.departureDay1" name="departureDay1" /></td>
						<td><input type="checkbox" [checked]="entry.departureDay2" name="departureDay2" /></td>
						<td><input type="checkbox" [checked]="entry.departureDay3" name="departureDay3" /></td>
						<td><input type="checkbox" [checked]="entry.departureDay4" name="departureDay4" /></td>
						<td><input type="checkbox" [checked]="entry.departureDay5" name="departureDay5" /></td>
						<td><input type="checkbox" [checked]="entry.departureDay6" name="departureDay6" /></td>
						<td><input type="checkbox" [checked]="entry.departureDay7" name="departureDay7" /></td>
					</tr>
				</table>
			</div>
			
			
			<div class="action-buttons">
				<button ez-if="entry.entryNo ? true : false" [onclick]="widget.deleteEntry_Click">{{_('Delete')}}</button>
				
				<button [onclick]="widget.cancelEntry_Click">{{_('Cancel')}}</button>
				
				<button [onclick]="widget.saveEntry_Click">{{_('Save')}}</button>
			</div>
		</div>
	`;
	
	
	
	
	container = null;
	startDate = null;
	daysShown = 60;
	
	dayprice = {};
	dayEntries = [];
	dayEntryCount = 1;
	
	selectedDayEntry = null;
	
	init(e) {
		this.container = e;
		
		this.startDate = start_of_month();
		
		this.render();
		
		let id;
		if (id = getUrlParam('id')) {
			this.loadDayprice( id );
		}
		
	}
	
	async loadDayprice( id ) {
		showLoadingForm( '.dayprice-edit-widget' );
		let r = await postJson('/service/sales/rental/dayprice.do', {
			a: 'view',
			daypriceId: id
		});
		
		let json = await r.json();
		
		if (json.error) {
			showErrorWidget( json );
			return;
		}
		
		this.dayprice = json.dayprice;
		
		for(let i in json.dayprice.entries) {
			this.addDaypriceEntry( json.dayprice.entries[i] );
		}
		
		this.render();
	}
	
	
	
	render() {
		let tpl = new EzTemplate( this.container );
		tpl.setObject('widget', this);
		tpl.setVar('startDate', this.startDate);
		tpl.setVar('daysShown', this.daysShown);
		tpl.setVar('dayprice', this.dayprice);
		
		tpl.loadHtml( this.tpl );
		tpl.render();
		
		$('input[name=startDate]').on('dp.change', (evt) => {
			this.startDate = evt.target.value;
			this.render();
		});
		$('input[name=daysShown]').on('change', (evt) => {
			this.daysShown = parseInt( evt.target.value );
			this.render();
			$('input[name=daysShown]').focus();
		});
		
		this.renderEntries();
	}
	
	renderEntries() {
		let d = format_date( this.startDate );
		
		let lastMonth = -1;
		let months = [];
		let days = [];
		for(let i=0; i < this.daysShown; i++) {
			
			let od = str2date( d );
			
			if (od.getMonth() != lastMonth) {
				
				let dim = days_in_month(od);
				
				let dl = (dim-od.getDate())+1;
				if (dl + i > this.daysShown)
					dl = this.daysShown - i;
				
				months.push({
					days_in_month: dim,
					days_left: dl,				// days left in table/overview. Used for colspan=""
					month: od.getMonth()+1,
					year: od.getFullYear(),
					short_year: od.getFullYear().toString().substring(2)
				});
				lastMonth = od.getMonth();
			}

			days.push({
				dateObject: od,
				dayNo: od.getDay(),
				date: od.getDate(),
				month: od.getMonth()+1,
				year: od.getFullYear()
			});
			
			d = next_day(d);
		}
		
		
		for(let i=0; i < this.dayEntries.length; i++) {
			let de = this.dayEntries[i];
			
			let arrivalDays = de.arrivalDays.split(',');
			let departureDays = de.departureDays.split(',');
			
			de.days = JSON.parse(JSON.stringify(days));
			for(let j=0; j < de.days.length; j++) {
				let arrivalDay = false;
				let departureDay = false;
				
				de.days[j].dateObject = new Date(de.days[j].dateObject);
				let d = de.days[j].dateObject;
				
				let arrivalDayNo = d.getDay() == 0 ? 7 : d.getDay();
				arrivalDay = arrivalDays.indexOf( String(arrivalDayNo) ) != -1 ? true : false;
				
				if (de.priceMethod == 'fixed') {
					let duration = parseInt(de.minDuration);
					
					// per night? => check if 
					if ( de.durationType == 'night' ) {
						for(let k in arrivalDays) {
							let depday = (parseInt(arrivalDays[k]) + duration+1);
							
							depday = depday%8;
							if (depday == 0) depday = 7;
							
							if (depday == d.getDay())
								departureDay = departureDays.indexOf(String(depday)) != -1 ? true : false;
						} 
						
					}
					if ( de.durationType == 'day' ) {
						for(let k in arrivalDays) {
							let depday = (parseInt(arrivalDays[k]) + (duration-1));
							depday = depday%8;
							if (depday == 0) depday = 7;
							
							if (depday == d.getDay())
								departureDay = departureDays.indexOf(String(depday)) != -1 ? true : false;
						}
					}
					
				}
				else {
					departureDay = departureDays.indexOf( String(arrivalDayNo) ) != -1 ? true : false;
				}
				
//				console.log('ad', arrivalDay, departureDay);
				
				de.days[j].arrivalDay = arrivalDay;
				de.days[j].departureDay = departureDay;
			}
			
		}
		
		
		
		let tpl = new EzTemplate('#container-dp-entries');
		tpl.loadHtml( this.tplEntryList);
		tpl.setObject('widget', this);
		
		tpl.setVar('months', months);
		tpl.setVar('days', days);
		tpl.setVar('currentYear', new Date().getFullYear());
		
		tpl.setVar('dayEntries', this.dayEntries);
		
		tpl.render();
		
		
		// yug.. no nice way to do it with templates
		$('#container-dp-entries table thead tr').prepend('<td class="entry-name"></td>');
	}
	
	
	
	addDaypriceEntry_Click() {
		let entry = {};
		entry.description = '';
		entry.price = '';
		entry.start = this.startDate;
		entry.minDuration = 1;
		entry.arrivalDays = '1,2,3,4,5,6,7';
		entry.departureDays = '1,2,3,4,5,6,7';
		
		this.editDaypriceEntry( entry );
	}
	
	editDaypriceEntry( entry ) {
		this.selectedDayEntry = entry;
		
		if (entry.arrivalDays) {
			let arrivalDays = entry.arrivalDays.split(/,/);
			entry.arrivalDay1 = arrivalDays.indexOf('1') != -1 ? true : false;
			entry.arrivalDay2 = arrivalDays.indexOf('2') != -1 ? true : false;
			entry.arrivalDay3 = arrivalDays.indexOf('3') != -1 ? true : false;
			entry.arrivalDay4 = arrivalDays.indexOf('4') != -1 ? true : false;
			entry.arrivalDay5 = arrivalDays.indexOf('5') != -1 ? true : false;
			entry.arrivalDay6 = arrivalDays.indexOf('6') != -1 ? true : false;
			entry.arrivalDay7 = arrivalDays.indexOf('7') != -1 ? true : false;
		}
		if (entry.departureDays) {
			let departureDays = entry.departureDays.split(/,/);
			entry.departureDay1 = departureDays.indexOf('1') != -1 ? true : false;
			entry.departureDay2 = departureDays.indexOf('2') != -1 ? true : false;
			entry.departureDay3 = departureDays.indexOf('3') != -1 ? true : false;
			entry.departureDay4 = departureDays.indexOf('4') != -1 ? true : false;
			entry.departureDay5 = departureDays.indexOf('5') != -1 ? true : false;
			entry.departureDay6 = departureDays.indexOf('6') != -1 ? true : false;
			entry.departureDay7 = departureDays.indexOf('7') != -1 ? true : false;
		}
		
		let tpl  = new EzTemplate('#container-dp-entry');
		tpl.loadHtml( this.tplEntryForm );
		
		tpl.setVar('entry', entry);
		tpl.setObject('widget', this);
		
		tpl.render();
		
		this.priceMethod_Change(); 
	}
	
	priceMethod_Change() {
		$('.dayprice-entry-form .min-max-duration').addClass('hidden');
		$('.dayprice-entry-form .duration').addClass('hidden');
		
		if ( elval('priceMethod') == 'fixed' ) {
			$('.dayprice-entry-form .duration').removeClass('hidden');
			$('.dayprice-entry-form .container-departure-days').hide();
		}
		else {
			$('.dayprice-entry-form .min-max-duration').removeClass('hidden');
			$('.dayprice-entry-form .container-departure-days').show();
		}
	}
	
	editEntry_Click(evt, tr) {
		let daypriceEntry = tr.de;
		this.editDaypriceEntry( daypriceEntry );
	}
	
	deleteEntry_Click() {
		showConfirmation(_('Delete'), _('Are you sure to delete this entry?'), () => {
			this.dayEntries = this.dayEntries.filter( (e) => {
				return e.entryNo == this.selectedDayEntry.entryNo ? false : true;
			});
			
			this.selectedDayEntry = null;
			
			document.querySelector('#container-dp-entry').innerHTML = '';
			
			this.renderEntries();
		});
	}
	
	cancelEntry_Click() {
		document.querySelector('#container-dp-entry').innerHTML = '';
		this.selectedDayEntry = null;
	}
	
	entryToObject() {
		let e = serialize2object('.dayprice-entry-form');
		e.startDate = e.dpStartDate;
		e.endDate = e.dpEndDate;

		e = Object.assign( this.selectedDayEntry, e );
		if (e.priceMethod == 'fixed')
			e.minDuration = e.duration;

		let arrivalDays = [];
		if (elval('arrivalDay1')) arrivalDays.push('1');
		if (elval('arrivalDay2')) arrivalDays.push('2');
		if (elval('arrivalDay3')) arrivalDays.push('3');
		if (elval('arrivalDay4')) arrivalDays.push('4');
		if (elval('arrivalDay5')) arrivalDays.push('5');
		if (elval('arrivalDay6')) arrivalDays.push('6');
		if (elval('arrivalDay7')) arrivalDays.push('7');

		let departureDays = [];
		if (elval('departureDay1')) departureDays.push('1');
		if (elval('departureDay2')) departureDays.push('2');
		if (elval('departureDay3')) departureDays.push('3');
		if (elval('departureDay4')) departureDays.push('4');
		if (elval('departureDay5')) departureDays.push('5');
		if (elval('departureDay6')) departureDays.push('6');
		if (elval('departureDay7')) departureDays.push('7');

		e.arrivalDays = arrivalDays.join(',');
		e.departureDays = departureDays.join(',');
		
		return e;
	}
	
	saveEntry_Click() {
		let e = this.entryToObject();
				
		this.addDaypriceEntry( e );
		
		document.querySelector('#container-dp-entry').innerHTML = '';
		
		this.renderEntries();
		
		this.selectedDayEntry = null;
	}
	
	addDaypriceEntry( entry ) {
		if (entry.entryNo) {
			for(let i=0; i < this.dayEntries.length; i++) {
				if ( this.dayEntries[i].entryNo == entry.entryNo ) {
					this.dayEntries[i] = entry;
					return;
				}
			}
		}
		else {
			entry.entryNo = this.dayEntryCount++;
			this.dayEntries.push( entry );
		}
	}
	
	
	getState() {
		let state = {};
		
		let c = this.container;
		if (typeof c == 'string') c = document.querySelector( c );
		
		if (this.dayprice) {
			if (this.dayprice.daypriceId) {
				state.daypriceId = this.dayprice.daypriceId;
			}
		}
		
		state.name      = c.querySelector('input[name=name]').value;
		
		state.entries = this.dayEntries;
		
		return state;
	}
	
	
	
	delete_Click() {
		showConfirmation('Delete', _('Are you sure to delete this record?'), async () => {
			showLoadingForm('.dayprice-edit-widget');
			
			await postJson('/service/sales/rental/dayprice.do', {
				a: 'delete',
				daypriceId: this.dayprice.daypriceId
			});
			
			gotoRoute( '/masterdata/sales/dayprice/' );
		});
	}
	
	
	async save_Click() {
		
		if (this.selectedDayEntry != null) {
			this.saveEntry_Click();
		}
		
		
		let state = this.getState();
		
		let r = await postJson( '/service/sales/rental/dayprice.do', {
			a: 'save',
			dayprice: state
		});
		
		let json = await r.json();
		
		if (json.success) {
			reportUserMessage( json.message );
			gotoRoute( '/masterdata/sales/dayprice/edit/?id=' + json.daypriceId );
		}
		else {
			reportUserError( json.message );
		}
		
	}
	
	
	goBack_Click() {
		gotoRoute( '/masterdata/sales/dayprice/' );
	}
	
	
}



